<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

if (!isset($_SESSION['username'])) {
    header("Location: /perpustakaan/login.php");
    exit();
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Sistem Perpustakaan - UAS RPL</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
</head>
<body>
<nav class="navbar navbar-expand-lg navbar-dark bg-dark mb-4 shadow-sm">
    <div class="container">
        <a class="navbar-brand fw-bold" href="/perpustakaan/index.php"><i class="bi bi-book-half"></i> SIPERPUS</a>
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav me-auto">
                <li class="nav-item">
                    <a class="nav-link" href="/perpustakaan/index.php">Dashboard</a>
                </li>
                
                <li class="nav-item">
                    <a class="nav-link" href="/perpustakaan/modules/buku/index.php">Daftar Buku</a>
                </li>

                <?php if ($_SESSION['role'] == 'admin'): ?>
                    <li class="nav-item border-start ms-2 ps-2">
                        <a class="nav-link text-info" href="/perpustakaan/modules/buku/index.php">
                            <i class="bi bi-gear-fill"></i> Kelola Buku
                        </a>
                    </li>
                <?php endif; ?>

                <li class="nav-item">
                    <a class="nav-link" href="/perpustakaan/modules/transaksi/peminjaman.php">Sewa Buku</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="/perpustakaan/modules/transaksi/riwayat.php">Riwayat Pinjam</a>
                </li>
                <li class="nav-item">
                <a class="nav-link" href="/perpustakaan/modules/transaksi/pengembalian.php">Pengembalian</a>
                </li>
            </ul>
            
            <div class="d-flex align-items-center">
                <span class="navbar-text me-3 text-white">
                    <i class="bi bi-person-circle"></i> <?= $_SESSION['username']; ?> 
                    <span class="badge bg-secondary"><?= strtoupper($_SESSION['role']); ?></span>
                </span>
                <a class="btn btn-outline-danger btn-sm" href="/perpustakaan/logout.php">Logout</a>
            </div>
        </div>
    </div>
</nav>
<div class="container">