<?php
require_once '../../config/database.php';
include '../../templates/header.php';

// Ambil ID User dari session
$id_user_login = $_SESSION['id_user'];

// Query join 3 tabel: transaksi, buku, dan users agar datanya lengkap
// Kita filter berdasarkan id_user agar user cuma bisa lihat pinjamannya sendiri
$query = "SELECT transaksi.*, buku.judul, users.nama_lengkap 
          FROM transaksi 
          JOIN buku ON transaksi.id_buku = buku.id_buku 
          JOIN users ON transaksi.id_user = users.id_user 
          WHERE transaksi.id_user = '$id_user_login' 
          ORDER BY transaksi.tgl_pinjam DESC";

$result = mysqli_query($conn, $query);
?>

<div class="container mt-4">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h3><i class="bi bi-clock-history"></i> Riwayat Peminjaman Kamu</h3>
        <a href="peminjaman.php" class="btn btn-primary btn-sm">Pinjam Buku Lagi</a>
    </div>

    <div class="card shadow-sm border-0">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead class="table-light">
                        <tr>
                            <th>No</th>
                            <th>Judul Buku</th>
                            <th>Tgl Pinjam</th>
                            <th>Deadline Kembali</th>
                            <th>Denda</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php 
                        $no = 1;
                        while ($row = mysqli_fetch_assoc($result)) : 
                            // --- LOGIKA HITUNG DENDA (Rp 1.000 per hari) ---
                            $tgl_kembali = new DateTime($row['tgl_kembali']);
                            $tgl_sekarang = new DateTime(date('Y-m-d'));
                            $denda = 0;

                            if ($tgl_sekarang > $tgl_kembali && $row['status'] == 'dipinjam') {
                                $selisih = $tgl_sekarang->diff($tgl_kembali);
                                $hari = $selisih->days;
                                $denda = $hari * 1000; // Contoh denda 1000 per hari
                            }
                        ?>
                        <tr>
                            <td><?= $no++; ?></td>
                            <td><strong><?= $row['judul']; ?></strong></td>
                            <td><?= date('d/m/Y', strtotime($row['tgl_pinjam'])); ?></td>
                            <td><?= date('d/m/Y', strtotime($row['tgl_kembali'])); ?></td>
                            <td>
                                <?php if ($denda > 0): ?>
                                    <span class="text-danger fw-bold">Rp <?= number_format($denda, 0, ',', '.'); ?></span>
                                <?php else: ?>
                                    <span class="text-success">Tidak Ada</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if ($row['status'] == 'dipinjam') : ?>
                                    <span class="badge bg-warning text-dark">Masih Dipinjam</span>
                                <?php else : ?>
                                    <span class="badge bg-success">Sudah Dikembalikan</span>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endwhile; ?>

                        <?php if (mysqli_num_rows($result) == 0) : ?>
                            <tr>
                                <td colspan="6" class="text-center text-muted">Kamu belum pernah meminjam buku.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php include '../../templates/footer.php'; ?>