<?php
require_once '../../config/database.php';
include '../../templates/header.php';

// --- LOGIKA PROSES KEMBALI & HITUNG DENDA ---
if (isset($_GET['id'])) {
    $id_transaksi = $_GET['id'];

    // 1. Ambil data transaksi untuk cek tanggal kembali
    $cek_data = mysqli_query($conn, "SELECT * FROM transaksi WHERE id_transaksi = '$id_transaksi'");
    $t = mysqli_fetch_assoc($cek_data);
    $id_buku = $t['id_buku'];
    
    // 2. Hitung Denda
    $tgl_kembali = new DateTime($t['tgl_kembali']);
    $tgl_sekarang = new DateTime(date('Y-m-d'));
    $total_denda = 0;

    if ($tgl_sekarang > $tgl_kembali) {
        $selisih = $tgl_sekarang->diff($tgl_kembali);
        $hari = $selisih->days;
        $total_denda = $hari * 1000; // Denda per hari Rp 1.000
    }

    // 3. Update Transaksi (Status, Tanggal Selesai, dan Denda)
    $update_transaksi = mysqli_query($conn, "UPDATE transaksi SET 
        status = 'kembali', 
        denda = '$total_denda' 
        WHERE id_transaksi = '$id_transaksi'");

    // 4. Tambahkan stok buku kembali (+1)
    $update_stok = mysqli_query($conn, "UPDATE buku SET stok = stok + 1 WHERE id_buku = '$id_buku'");

    if ($update_transaksi && $update_stok) {
        $pesan = ($total_denda > 0) ? "Buku kembali. Denda yang harus dibayar: Rp " . number_format($total_denda, 0, ',', '.') : "Buku berhasil dikembalikan tepat waktu!";
        echo "<script>alert('$pesan'); window.location='pengembalian.php';</script>";
    }
}

// Ambil data buku yang masih dipinjam
$query = "SELECT transaksi.*, buku.judul, users.nama_lengkap 
          FROM transaksi 
          JOIN buku ON transaksi.id_buku = buku.id_buku 
          JOIN users ON transaksi.id_user = users.id_user 
          WHERE transaksi.status = 'dipinjam'";
$result = mysqli_query($conn, $query);
?>

<div class="container mt-4">
    <h3 class="mb-4 text-primary"><i class="bi bi-cash-stack"></i> Pengelolaan Pengembalian & Denda</h3>

    <div class="alert alert-info">
        <strong>Ketentuan Denda:</strong> Keterlambatan dikenakan denda <b>Rp 1.000 / hari</b> dari tanggal deadline.
    </div>

    <div class="card shadow-sm border-0">
        <div class="card-body">
            <table class="table table-striped align-middle">
                <thead class="table-dark">
                    <tr>
                        <th>Peminjam</th>
                        <th>Judul Buku</th>
                        <th>Tgl Pinjam</th>
                        <th>Deadline</th>
                        <th>Status Denda</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while ($row = mysqli_fetch_assoc($result)) : 
                        // Hitung estimasi denda untuk tampilan tabel
                        $deadline = new DateTime($row['tgl_kembali']);
                        $now = new DateTime(date('Y-m-d'));
                        $est_denda = 0;
                        if ($now > $deadline) {
                            $est_denda = ($now->diff($deadline))->days * 1000;
                        }
                    ?>
                    <tr>
                        <td><?= $row['nama_lengkap']; ?></td>
                        <td><?= $row['judul']; ?></td>
                        <td><?= date('d/m/Y', strtotime($row['tgl_pinjam'])); ?></td>
                        <td><?= date('d/m/Y', strtotime($row['tgl_kembali'])); ?></td>
                        <td>
                            <?php if ($est_denda > 0): ?>
                                <span class="badge bg-danger">Terlambat (Rp <?= number_format($est_denda, 0, ',', '.'); ?>)</span>
                            <?php else: ?>
                                <span class="badge bg-success">Aman</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <a href="pengembalian.php?id=<?= $row['id_transaksi']; ?>" 
                               class="btn btn-primary btn-sm" 
                               onclick="return confirm('Konfirmasi pengembalian buku ini?')">
                               Proses Kembali
                            </a>
                        </td>
                    </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php include '../../templates/footer.php'; ?>