<?php
require_once '../../config/database.php';
include '../../templates/header.php';

// Ambil ID User yang sedang login dari session
// Kita asumsikan saat login kamu sudah menyimpan ID User di $_SESSION['id_user']
$id_user_login = $_SESSION['id_user']; 
$nama_user_login = $_SESSION['nama_lengkap'];

// Ambil daftar buku yang stoknya masih ada
$buku_list = mysqli_query($conn, "SELECT * FROM buku WHERE stok > 0");

if (isset($_POST['pinjam'])) {
    $id_buku    = $_POST['id_buku'];
    $tgl_pinjam = date('Y-m-d');
    $tgl_kembali = date('Y-m-d', strtotime('+7 days')); // Deadline 1 minggu

    // VALIDASI STOK: Cek sekali lagi sebelum insert
    $cek_stok = mysqli_query($conn, "SELECT stok FROM buku WHERE id_buku = '$id_buku'");
    $data_buku = mysqli_fetch_assoc($cek_stok);

    if ($data_buku['stok'] > 0) {
        // 1. Masukkan data ke transaksi (Peminjam otomatis user yang login)
        $query_transaksi = "INSERT INTO transaksi (id_buku, id_user, tgl_pinjam, tgl_kembali, status) 
                            VALUES ('$id_buku', '$id_user_login', '$tgl_pinjam', '$tgl_kembali', 'dipinjam')";
        
        // 2. Potong stok buku
        $query_update_stok = "UPDATE buku SET stok = stok - 1 WHERE id_buku = '$id_buku'";

        if (mysqli_query($conn, $query_transaksi) && mysqli_query($conn, $query_update_stok)) {
            echo "<script>alert('Berhasil Pinjam! Silakan ambil bukunya di petugas.'); window.location='riwayat.php';</script>";
        }
    } else {
        echo "<script>alert('Yah, keduluan orang lain. Stok baru saja habis!');</script>";
    }
}
?>

<div class="row justify-content-center">
    <div class="col-md-6">
        <div class="card shadow border-0">
            <div class="card-header bg-dark text-white text-center">
                <h5 class="mb-0">Form Peminjaman </h5>
            </div>
            <div class="card-body">
                <div class="alert alert-info">
                    Halo <strong><?= $nama_user_login; ?></strong>, silakan pilih buku yang ingin kamu pinjam.
                </div>
                
                <form method="POST">
                    <input type="hidden" name="id_user" value="<?= $id_user_login; ?>">

                    <div class="mb-3">
                        <label class="form-label fw-bold">Pilih Koleksi Buku</label>
                        <select name="id_buku" class="form-select form-select-lg" required>
                            <option value="">-- Pilih Buku --</option>
                            <?php while($bk = mysqli_fetch_assoc($buku_list)): ?>
                                <option value="<?= $bk['id_buku']; ?>">
                                    <?= $bk['judul']; ?> (Tersedia: <?= $bk['stok']; ?>)
                                </option>
                            <?php endwhile; ?>
                        </select>
                    </div>

                    <div class="row">
                        <div class="col-6 mb-3">
                            <label class="form-label">Tgl Pinjam</label>
                            <input type="text" class="form-control bg-light" value="<?= date('d M Y'); ?>" readonly>
                        </div>
                        <div class="col-6 mb-3">
                            <label class="form-label">Tgl Kembali</label>
                            <input type="text" class="form-control bg-light" value="<?= date('d M Y', strtotime('+7 days')); ?>" readonly>
                        </div>
                    </div>

                    <div class="d-grid gap-2 mt-3">
                        <button type="submit" name="pinjam" class="btn btn-primary btn-lg">Pinjam Sekarang</button>
                        <a href="../../index.php" class="btn btn-link text-muted">Batal</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?php include '../../templates/footer.php'; ?>