<?php
include '../../config/database.php';
include '../../templates/header.php'; // Pastikan header sudah ada session_start()

// Ambil data buku dari database
$query = "SELECT * FROM buku ORDER BY id_buku DESC";
$result = mysqli_query($conn, $query);
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2>Daftar Koleksi Buku</h2>
    <?php if ($_SESSION['role'] == 'admin'): ?>
        <a href="tambah.php" class="btn btn-success">+ Tambah Buku Baru</a>
    <?php endif; ?>
</div>

<div class="card shadow-sm">
    <div class="card-body">
        <table class="table table-bordered table-striped">
    <thead class="table-dark">
        <tr>
            <th>No</th>
            <th>Judul</th>
            <th>Pengarang</th>
            <th>Penerbit</th>
            <th>ISBN</th>
            <th>Stok</th>
            <?php if ($_SESSION['role'] == 'admin'): ?>
                <th>Aksi</th>
            <?php endif; ?>
        </tr>
    </thead>
    <tbody>
    <?php 
    $no = 1;
    while ($row = mysqli_fetch_assoc($result)): 
    ?>
    <tr>
        <td><?= $no++; ?></td>
        <td><strong><?= $row['judul']; ?></strong></td>
        <td><?= $row['pengarang']; ?></td>
        <td><?= $row['penerbit']; ?></td>
        <td><?= $row['isbn']; ?></td>
        <td>
            <?php if ($row['stok'] > 0): ?>
                <span class="badge bg-success"><?= $row['stok']; ?> Tersedia</span>
            <?php else: ?>
                <span class="badge bg-danger">Stok Kosong</span>
            <?php endif; ?>
        </td>
        
        <?php if ($_SESSION['role'] == 'admin'): ?>
        <td>
            <a href="edit.php?id=<?= $row['id_buku']; ?>" class="btn btn-sm btn-warning">
                <i class="bi bi-pencil"></i> Edit
            </a>
            
            <a href="hapus.php?id=<?= $row['id_buku']; ?>" 
               class="btn btn-sm btn-danger" 
               onclick="return confirm('Apakah Anda yakin ingin menghapus buku \'<?= $row['judul']; ?>\'? Tindakan ini tidak dapat dibatalkan.')">
                <i class="bi bi-trash"></i> Hapus
            </a>
        </td>
        <?php endif; ?>
    </tr>
    <?php endwhile; ?>
</tbody>
</table>
    </div>
</div>

<?php include '../../templates/footer.php'; ?>