<?php
// Pastikan header.php sudah punya session_start()
include 'templates/header.php';
include 'config/database.php';

// Proteksi: Jika session hilang, paksa balik ke login
if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit();
}

// 1. Hitung Total Buku
$jml_buku = mysqli_num_rows(mysqli_query($conn, "SELECT * FROM buku"));

// 2. HITUNG TOTAL USER (Ini yang kita ganti dari Anggota)
$query_user = "SELECT * FROM users";
$result_user = mysqli_query($conn, $query_user);
$jml_user = mysqli_num_rows($result_user);

// 3. Hitung Buku yang Sedang Dipinjam
$jml_pinjam = mysqli_num_rows(mysqli_query($conn, "SELECT * FROM transaksi WHERE status='dipinjam'"));
?>

<div class="container mt-4">
    <div class="row">
        <div class="col-md-12">
            <div class="alert alert-primary shadow-sm border-0">
                <h4>Selamat Datang di SIPERPUS, <strong><?php echo $_SESSION['username']; ?></strong>!</h4>
                <p class="mb-0">Status Akses: <span class="badge bg-dark"><?php echo strtoupper($_SESSION['role']); ?></span></p>
            </div>
        </div>
    </div>

    <div class="row mt-3 text-center">
        <div class="col-md-4">
            <div class="card text-white bg-success mb-3 shadow border-0">
                <div class="card-body">
                    <h5 class="card-title"><i class="bi bi-journal-bookmark"></i> Total Koleksi Buku</h5>
                    <p class="card-text h2"><?php echo $jml_buku; ?></p>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card text-white bg-info mb-3 shadow border-0">
                <div class="card-body">
                    <h5 class="card-title"><i class="bi bi-people-fill"></i> Total User Terdaftar</h5>
                    <p class="card-text h2"><?php echo $jml_user; ?></p>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card text-white bg-warning mb-3 shadow border-0">
                <div class="card-body">
                    <h5 class="card-title"><i class="bi bi-arrow-repeat"></i> Buku Sedang Dipinjam</h5>
                    <p class="card-text h2"><?php echo $jml_pinjam; ?></p>
                </div>
            </div>
        </div>
    </div>

    <div class="row mt-4">
        <div class="col-md-8">
            <div class="card shadow-sm border-0">
                <div class="card-header bg-white">
                    <h5 class="mb-0"><i class="bi bi-info-circle text-primary"></i> Informasi Sistem</h5>
                </div>
                <div class="card-body">
                    <p>Selamat datang di dashboard SIPERPUS. Di sini Anda bisa melihat statistik perpustakaan secara real-time.</p>
                    <ul>
                        <li>Pastikan stok buku akurat sebelum melakukan transaksi.</li>
                        <li>Sistem menggunakan data <strong>User</strong> untuk proses peminjaman.</li>
                        <li>Denda dihitung otomatis sejak hari pertama keterlambatan.</li>
                    </ul>
                </div>
            </div>
        </div>
        
        <div class="col-md-4">
            <div class="card shadow-sm border-0">
                <div class="card-header bg-white text-center">
                    <h5 class="mb-0">Aksi Cepat</h5>
                </div>
                <div class="card-body d-grid gap-2">
                    <?php if($_SESSION['role'] == 'admin') : ?>
                        <a href="/perpustakaan/modules/buku/index.php" class="btn btn-outline-success">
                            <i class="bi bi-pencil-square"></i> Kelola Master Buku
                        </a>
                    <?php endif; ?>
                    
                    <a href="/perpustakaan/modules/transaksi/peminjaman.php" class="btn btn-primary">
                        <i class="bi bi-plus-lg"></i> Sewa Buku Baru
                    </a>
                    
                    <a href="/perpustakaan/modules/transaksi/riwayat.php" class="btn btn-outline-primary">
                        <i class="bi bi-clock-history"></i> Riwayat Pinjam Saya
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include 'templates/footer.php'; ?>